% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{pagoda.effective.cells}
\alias{pagoda.effective.cells}
\title{Estimate effective number of cells based on lambda1 of random gene sets}
\usage{
pagoda.effective.cells(pwpca, start = NULL)
}
\arguments{
\item{pwpca}{result of the pagoda.pathway.wPCA() call with n.randomizations > 1}

\item{start}{optional starting value for the optimization (if the NLS breaks, trying high starting values usually fixed the local gradient problem)}
}
\value{
effective number of cells
}
\description{
Examines the dependency between the amount of variance explained by the first principal component
of a gene set and the number of genes in a gene set to determine the effective number of cells
for the Tracy-Widom distribution
}
\examples{
data(pollen)
cd <- clean.counts(pollen)
\donttest{
knn <- knn.error.models(cd, k=ncol(cd)/4, n.cores=10, min.count.threshold=2, min.nonfailed=5, max.model.plots=10)
varinfo <- pagoda.varnorm(knn, counts = cd, trim = 3/ncol(cd), max.adj.var = 5, n.cores = 1, plot = FALSE)
pwpca <- pagoda.pathway.wPCA(varinfo, go.env, n.components=1, n.cores=10, n.internal.shuffles=50)
pagoda.effective.cells(pwpca)
}

}

