% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{winsorize.matrix}
\alias{winsorize.matrix}
\title{Winsorize matrix}
\usage{
winsorize.matrix(mat, trim)
}
\arguments{
\item{mat}{matrix}

\item{trim}{fraction of outliers (on each side) that should be Winsorized, or (if the value is  >= 1) the number of outliers to be trimmed on each side}
}
\value{
Winsorized matrix
}
\description{
Sets the ncol(mat)*trim top outliers in each row to the next lowest value same for the lowest outliers
}
\examples{
set.seed(0)
mat <- matrix( c(rnorm(5*10,mean=0,sd=1), rnorm(5*10,mean=5,sd=1)), 10, 10)  # random matrix
mat[1,1] <- 1000  # make outlier
range(mat)  # look at range of values
win.mat <- winsorize.matrix(mat, 0.1)
range(win.mat)  # note outliers removed

}

