% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{subdistsmult}
\alias{subdistsmult}
\title{Computes the dot product between the subcentroids from the indexed reference and the subvectors of an element of the query dataset. 
Returns an M by k matrix. Used as an intermediate step (in NNfirst and NNmult) for calculating
an approximation of the cosine similarity between the query and the reference.}
\usage{
subdistsmult(subcentroids, query_chunks, M, k, cellnum)
}
\arguments{
\item{subcentroids}{A list of matrices containing the subcentroids of each chunk.}

\item{query_chunks}{A list of matrices containing the chunks of the query dataset after it has been split
according to the product quantization method}

\item{M}{An integer specifying the number of chunks}

\item{k}{An integer specifying the number of subcentroids per chunk}

\item{cellnum}{An integer specifying the column of the query dataset we wish to consider}
}
\description{
Computes the dot product between the subcentroids from the indexed reference and the subvectors of an element of the query dataset. 
Returns an M by k matrix. Used as an intermediate step (in NNfirst and NNmult) for calculating
an approximation of the cosine similarity between the query and the reference.
}
