.transformFactor <- function(f) {
    if (is.null(f)) {
        list(index=NULL, names=NULL)
    } else {
        f <- factor(f)
        list(index=as.integer(f) - 1L, names=levels(f))
    }
}

.checkNeighborIndices <- function(index, num.neighbors) {
    stopifnot(length(dim(index)) == 2L)
    r <- range(index)
    if (!is.finite(r[1]) || r[1] < 1L) {
        stop("'index' should contain finite positive integers")
    }
    if (!is.finite(r[2]) || r[2] > ncol(index)) {
        stop("'index' should contain finite integers no greater than 'ncol(index)'")
    }
    if (nrow(index) != num.neighbors) {
        warning("'nrow(index)' is not consistent with 'num.neighbors'")
    }
}
