% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/computeClrm1Factors.R
\name{computeClrm1Factors}
\alias{computeClrm1Factors}
\title{Compute size factors for ADT counts}
\usage{
computeClrm1Factors(x, num.threads = 1)
}
\arguments{
\item{x}{A matrix-like object containing ADT count data.
Rows correspond to tags and columns correspond to cells.}

\item{num.threads}{Number of threads to use.}
}
\value{
Numeric vector containing the CLRm1 size factor for each cell.
Note that these size factors are not centered and should be passed through, e.g., \code{\link{centerSizeFactors}} before normalization.
}
\description{
Compute size factors from an ADT count matrix using the CLRm1 method.
This is a variant of the centered log-ratio (CLR) method, where the size factors are defined from the geometric mean of counts within each cell.
}
\examples{
library(Matrix)
x <- abs(rsparsematrix(1000, 100, 0.1) * 10)
head(computeClrm1Factors(x))

}
\seealso{
\url{https://github.com/libscran/clrm1}, for a description of the CLRm1 method.
}
\author{
Aaron Lun
}
