% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/citeseqApp.R
\name{getSubclusteringFeatures}
\alias{getSubclusteringFeatures}
\title{get lmFit F-stat based collection of n genes most varying in mean across subclusters}
\usage{
getSubclusteringFeatures(inlist, clname, n = 20)
}
\arguments{
\item{inlist}{list of SingleCellExperiments (SCEs) formed by scran::quickSubCluster}

\item{clname}{character(1) name of cluster SCE to assess}

\item{n}{numeric(1) number to preserve}
}
\value{
list with two elements, feat = rowData corresponding to variable genes, stats = topTable result
}
\description{
get lmFit F-stat based collection of n genes most varying in mean across subclusters
}
\note{
Symbol will be taken from feat and placed in stats component if available
}
\examples{
all.sce <- getCh12AllSce()
scl <- getSubclusteringFeatures(all.sce, "3", 10)
names(scl)
}
