% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_variant_list.R
\name{plot_variant_list}
\alias{plot_variant_list}
\title{Plot known variants list}
\usage{
plot_variant_list(variant_list, legend = TRUE, legend_size = 22,
  text_size = 14, palette = c("#4e8ce4", "#a6c6f2", "#999999",
  "#cccccc"))
}
\arguments{
\item{variant_list}{The data containing the variants (dataframe)}

\item{legend}{Show a legend for the genotype colours (boolean)}

\item{legend_size}{Size of the legend (numeric).}

\item{text_size}{Text size for axes and legend (numeric).}

\item{palette}{Nucleotide colour palette (4-element character vector)}
}
\value{
A ggplot2 graphical object.
}
\description{
Plot a genotype grid from a list of known variants
}
\details{
This function creates publication-ready plots from lists of known
 variants, taking a dataframe containing all the genotypes (on "A1/A2"
 format) for each sample (columns) and variant (row names).
}
\examples{
# Load test variant list
data(test_variant_list)

# Plot each variant's genotype per sample
genotype_grid <- plot_variant_list(test_variant_list)
}
