% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_clusteringKmeans.R
\name{copy_clust_info}
\alias{copy_clust_info}
\title{copy_clust_info}
\usage{
copy_clust_info(target, to_copy, row_ = "id", cluster_ = "cluster_id")
}
\arguments{
\item{target}{A data.table or GRanges returned from ssvFetch*, the target to
which cluster info will be added.}

\item{to_copy}{A data.table or GRanges returned from ssvSignalClustering,
from which to copy cluster if.}

\item{row_}{variable name mapped to row, likely id or gene name for ngs data.
Default is "id" and works with ssvFetch* output.}

\item{cluster_}{variable name to use for cluster info. Default is
"cluster_id".}
}
\value{
data.table or GRanges (whichever target is) containing row order and
cluster assignment derived from to_copy. Suitable for ssvSignalHeatmap and
related functions.
}
\description{
copy_clust_info
}
\examples{
data(CTCF_in_10a_narrowPeak_grs)
data(CTCF_in_10a_overlaps_gr)
data(CTCF_in_10a_profiles_dt)
#this takes cluster info from signal and applies to peak hits to
#create a heatmap of peak hits clustered by signal.
clust_dt1 = ssvSignalClustering(CTCF_in_10a_profiles_dt)
peak_hit_gr = ssvFetchGRanges(
  CTCF_in_10a_narrowPeak_grs,
  qgr = CTCF_in_10a_overlaps_gr
)
peak_hit_gr.clust = copy_clust_info(peak_hit_gr, clust_dt1)
peak_hit_gr.clust$hit = peak_hit_gr.clust$y > 0
ssvSignalHeatmap(peak_hit_gr.clust, fill_ = "hit") +
  scale_fill_manual(values = c("FALSE" = "gray90", "TRUE" = "black"))
}
