% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_feature_plots.R
\name{ssvFeatureVenn}
\alias{ssvFeatureVenn}
\title{ssvFeatureVenn}
\usage{
ssvFeatureVenn(
  object,
  group_names = NULL,
  counts_txt_size = 5,
  counts_as_labels = FALSE,
  show_outside_count = FALSE,
  line_width = 3,
  circle_colors = NULL,
  fill_alpha = 0.3,
  line_alpha = 1,
  counts_color = NULL,
  counts_as_percent = FALSE,
  percentage_digits = 1,
  percentage_suffix = "\%",
  n_points = 200,
  return_data = FALSE
)
}
\arguments{
\item{object}{will be passed to \link{ssvMakeMembTable} for
conversion to membership matrix}

\item{group_names}{useful if names weren't provided or were lost in
creating membership matrix}

\item{counts_txt_size}{font size for count numbers}

\item{counts_as_labels}{if TRUE, geom_label is used instead of geom_text.
can be easier to read.}

\item{show_outside_count}{if TRUE, items outside of all sets are counted
outside. can be confusing.}

\item{line_width}{uses size aesthetic to control line width of circles.}

\item{circle_colors}{colors to use for circle line colors. Uses Dark2 set
from RColorBrewer by default.}

\item{fill_alpha}{alpha value to use for fill, defaults to .3.}

\item{line_alpha}{numeric value from 0 to 1. Alpha value for circle line}

\item{counts_color}{character. single color to use for displaying counts}

\item{counts_as_percent}{if TRUE, convert counts to percentages in plots.}

\item{percentage_digits}{The number of digits to round percentages to, default is 1.}

\item{percentage_suffix}{The character to append to percentages, default is "\%".}

\item{n_points}{integer.  number of points to approximate circle with.
default is 200.}

\item{return_data}{logical.  If TRUE, return value is no longer ggplot and
is instead the data used to generate that plot. Default is FALSE.}
}
\value{
ggplot venn diagram
}
\description{
ggplot implementation of vennDiagram from limma package.  Currently limited
at 3 sets.  \link{ssvFeatureUpset} and \link{ssvFeatureBinaryHeatmap} are good options for
more than 3 sets. \link{ssvFeatureEuler} can work too but can take a very long time
to run for more than 5 or so.
}
\examples{
data(CTCF_in_10a_overlaps_gr)
ssvFeatureVenn(list(1:3, 2:6))
ssvFeatureVenn(CTCF_in_10a_overlaps_gr)
ssvFeatureVenn(S4Vectors::mcols(CTCF_in_10a_overlaps_gr)[,2:3])

ssvFeatureVenn(list(1:3, 2:6),
  counts_as_percent = TRUE,
  percentage_digits = 2)

ssvFeatureVenn(list(1:3, 2:6),
  counts_as_percent = TRUE,
  percentage_digits = 0,
  percentage_suffix = " \%",
  counts_txt_size = 12)
}
