% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_fetch_GRanges.R
\name{ssvFetchGRanges}
\alias{ssvFetchGRanges}
\title{Fetch coverage values for a list of GRanges.}
\usage{
ssvFetchGRanges(
  grs,
  qgr,
  file_attribs = data.frame(matrix(0, nrow = length(grs), ncol = 0)),
  unique_names = names(grs),
  names_variable = "sample",
  win_size = 50,
  win_method = c("sample", "summary")[1],
  summary_FUN = function(x, w) max(x),
  target_strand = c("*", "+", "-", "both")[1],
  use_coverage = NULL,
  attrib_var = "score",
  fill_value = 0,
  anchor = c("left", "left_unstranded", "center", "center_unstranded")[3],
  return_data.table = FALSE,
  n_cores = getOption("mc.cores", 1),
  force_skip_centerFix = FALSE
)
}
\arguments{
\item{grs}{a list of GRanges for which to calculate coverage.}

\item{qgr}{Set of GRanges to query.  For valid results the width of each
interval should be identical and evenly divisible by \code{win_size}.}

\item{file_attribs}{data.frame (1 row per item in grs) containing attributes
to append to results.}

\item{unique_names}{The column name where unique_names are stored. Default is
'sample'}

\item{names_variable}{The column name where unique_names are stored. Default
is 'sample'}

\item{win_size}{The window size that evenly divides widths in \code{qgr}.}

\item{win_method}{character.  one of c("sample", "summary").  Determines if
\code{\link{viewGRangesWinSample_dt}} or
\code{\link{viewGRangesWinSummary_dt}} is used to represent each region in
qgr.}

\item{summary_FUN}{function.  only relevant if win_method is "summary".
passed to \code{\link{viewGRangesWinSummary_dt}}.}

\item{target_strand}{character. if one of "+" or "-", reads are filtered to
match. ignored if any other value.}

\item{use_coverage}{boolean or NULL, if TRUE, query regions are scored by the
number of intervals overlapping.  Default of NULL checks if attrib_var is
"score" and uses coverage if so.}

\item{attrib_var}{character, column in mcols of GRanges to pull values from.
Default of "score" is compatible with internal coverage calculation or
bedgraph-like files.}

\item{fill_value}{numeric or character value to use where queried regions are
empty.  Default is 0 and appropriate for both calculated coverage and
bedgraph/bigwig like files.  Will automatically switch to "MISSING" if data
is guessed to be qualitative.}

\item{anchor}{character, one of c("center", "center_unstranded", "left",
"left_unstranded")}

\item{return_data.table}{logical. If TRUE the internal data.table is returned
instead of GRanges.  Default is FALSE.}

\item{n_cores}{integer number of cores to use. Uses mc.cores option if not
supplied.}

\item{force_skip_centerFix}{boolean, if TRUE all query ranges will be
used "as is".  This is already the case by default if win_method == "summary"
but may have applications where win_method == "sample".}
}
\value{
A tidy formatted GRanges (or data.table if specified) containing
fetched values.
}
\description{
\code{ssvFetchGRanges} Gets coverage values for each region of the query
GRanges (\code{qgr}). Values correspond to the center of each window of size
\code{win_size}.  A tidy formatted data.table object is returned suitable for
plotting using ggplots.
}
\examples{
data(CTCF_in_10a_narrowPeak_grs)
data(CTCF_in_10a_overlaps_gr)
ssvFetchGRanges(CTCF_in_10a_narrowPeak_grs, CTCF_in_10a_overlaps_gr, win_size = 200)
}
