% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/detection.R
\name{pOOBAH}
\alias{pOOBAH}
\title{Detection P-value based on ECDF of out-of-band signal}
\usage{
pOOBAH(
  sdf,
  return.pval = FALSE,
  combine.neg = TRUE,
  pval.threshold = 0.05,
  verbose = FALSE
)
}
\arguments{
\item{sdf}{a \code{SigDF}}

\item{return.pval}{whether to return p-values, instead of a
masked \code{SigDF}}

\item{combine.neg}{whether to combine negative control probes with
the out-of-band probes in simulating the signal background}

\item{pval.threshold}{minimum p-value to mask}

\item{verbose}{print more messages}
}
\value{
a \code{SigDF}, or a p-value vector if return.pval is TRUE
}
\description{
aka pOOBAH (p-vals by Out-Of-Band Array Hybridization)
}
\details{
The function takes a \code{SigDF} as input, computes detection p-value
using out-of-band probes empirical distribution and returns a new
\code{SigDF} with an updated mask slot.
}
\examples{
sdf <- sesameDataGet("EPIC.1.SigDF")
sum(sdf$mask)
sum(pOOBAH(sdf)$mask)

}
