% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc-uploader.R
\name{cli_list_tags}
\alias{cli_list_tags}
\title{List all the tags in project using Seven Bridges command line uploader}
\usage{
cli_list_tags(token = NULL, uploader = NULL, project = NULL, proxy = NULL)
}
\arguments{
\item{token}{Authentication token.}

\item{uploader}{The directory where Seven Bridges command line uploader
is located (the directory that contains the \code{bin/} directory).}

\item{project}{Unique identifier of the project,
for example, \code{"username/project-name"}.}

\item{proxy}{A proxy server through which the uploader should connect.
For details the proxy parameter format, see the part on parameter
\code{--proxy} in the reference below.}
}
\value{
Chracter vector of file tags in the project.
}
\description{
List all the tags in a destination project using Seven Bridges
command line uploader.
}
\examples{
token <- "your_token"
\dontrun{
cli_list_tags(
  token = token,
  uploader = "~/Downloads/sbg-uploader/",
  project = "username/project-name"
)}
}
\references{
\url{https://docs.sevenbridges.com/docs/upload-via-the-command-line}
}
\seealso{
See \code{\link{cli_upload}} for uploading files with
the command line uploader, \code{\link{cli_list_projects}} for listing
available projects.
}
