.outputSetupNavPanel2 <- function(input, output, rv) { # nocov start
    
    output$countFile <- shiny::renderUI({
        shiny::validate(
            shiny::need(
                shiny::isTruthy(input$useSampleData) ||
                    shiny::isTruthy(input$uploadedCountFile),
                "'Use demo data' or upload your own!"
            )
        )
        DT::renderDT(
            rv$data()$countFile %>%
                dplyr::slice_head(n = 100) %>%
                # To show all 100 rows across five pages
                DT::datatable(
                    options = list(
                        paging = TRUE
                    )
                )
        )
    })  




    
    output$sampleAnnoFile <- shiny::renderUI({
        shiny::req(input$load, rv$data())

        DT::renderDT(
            rv$data()$sampleAnnoFile %>%
                dplyr::slice_head(n = 100) %>%
                # To show all 100 rows across five pages
                DT::datatable(
                    options = list(
                        paging = TRUE
                    )
                )
        )
    })
    
} # nocov end
