\name{results}
\alias{results}
\docType{data}
\title{
Processed output data after using the function named "sigFeature.enfold()".
}
\description{
The variable "results" contains the output of the function named
"sigFeature.enfold()". To produce the output using
"sigFeature.enfold(x,y,"kfold",10)" function the dataset is devided
into 10 folds. Each time one fold is kept and the remaining k-1 folds
are used to generate the features. Later the one fold is used as test
sample and the remaining k-1 fold samples are used as training samples.
The "results" variable contains feature.ids (address of the features),
train.data.ids (training dataset ids), test.data.ids (test dataset ids),
train.data.level (training dataset levels) and test.data.level
(test dataset levels).
}
\usage{data("results")}
\format{
\preformatted{
The format is:
List of 10
    $ :List of 5
    ..$ feature.ids     : int [1:2204] 2064 2031 2035 1573 370  ...
    ..$ train.data.ids  : chr [1:24] "GSM42246" "GSM42248" ...
    ..$ test.data.ids   : chr [1:3] "GSM42263" "GSM42251" "GSM42260"
    ..$ train.data.level: Named num [1:24] 1 1 1 1 1 -1 -1 -1 -1 -1 ...
    .. ..- attr(*, "names")= chr [1:24] "GSM42246" "GSM42248" ...
    ..$ test.data.level : Named num [1:3] -1 1 1
    .. ..- attr(*, "names")= chr [1:3] "GSM42263" "GSM42251" "GSM42260"
    $ :List of 5
    ..$ feature.ids     : int [1:2204] 1577 2064 370 2035 2032 605 ...
    ..$ train.data.ids  : chr [1:24] "GSM42246" "GSM42248" ...
    ..$ test.data.ids   : chr [1:3] "GSM42267" "GSM42256" "GSM42261"
    ..$ train.data.level: Named num [1:24] 1 1 1 1 1 -1 -1 -1 -1 -1 ...
    .. ..- attr(*, "names")= chr [1:24] "GSM42246" "GSM42248" ...
    ..$ test.data.level : Named num [1:3] -1 1 1
    .. ..- attr(*, "names")= chr [1:3] "GSM42267" "GSM42256" "GSM42261"
    $ :List of 5
    ..$ feature.ids     : int [1:2204] 246 2006 1174 2032 1502 ...
    ..$ train.data.ids  : chr [1:24] "GSM42246" "GSM42248" ...
    ..$ test.data.ids   : chr [1:3] "GSM42265" "GSM42272" "GSM42255"
    ..$ train.data.level: Named num [1:24] 1 1 1 1 1 -1 -1 -1 ...
    .. ..- attr(*, "names")= chr [1:24] "GSM42246" "GSM42248" ...
    ..$ test.data.level : Named num [1:3] -1 -1 1
    .. ..- attr(*, "names")= chr [1:3] "GSM42265" "GSM42272" "GSM42255"
    $ :List of 5
    ..$ feature.ids     : int [1:2204] 2064 611 525 2035 2106  ...
    ..$ train.data.ids  : chr [1:24] "GSM42248" "GSM42250" ...
    ..$ test.data.ids   : chr [1:3] "GSM42246" "GSM42262" "GSM42253"
    ..$ train.data.level: Named num [1:24] 1 1 1 1 -1 -1 -1 ...
    .. ..- attr(*, "names")= chr [1:24] "GSM42248" "GSM42250" ...
    ..$ test.data.level : Named num [1:3] 1 -1 1
    .. ..- attr(*, "names")= chr [1:3] "GSM42246" "GSM42262" "GSM42253"
    $ :List of 5
    ..$ feature.ids     : int [1:2204] 370 726 2064 960 1519 2035 751 ...
    ..$ train.data.ids  : chr [1:24] "GSM42246" "GSM42248" ...
    ..$ test.data.ids   : chr [1:3] "GSM42252" "GSM42264" "GSM42257"
    ..$ train.data.level: Named num [1:24] 1 1 1 1 -1 -1 -1 ...
    .. ..- attr(*, "names")= chr [1:24] "GSM42246" "GSM42248" ...
    ..$ test.data.level : Named num [1:3] 1 -1 1
    .. ..- attr(*, "names")= chr [1:3] "GSM42252" "GSM42264"
    $ :List of 5
    ..$ feature.ids     : int [1:2204] 2064 1519 2032 370 1550 2035 805 ...
    ..$ train.data.ids  : chr [1:24] "GSM42246" "GSM42248" ...
    ..$ test.data.ids   : chr [1:3] "GSM42250" "GSM42269" "GSM42270"
    ..$ train.data.level: Named num [1:24] 1 1 1 1 -1 -1 -1 -1 -1 -1 ...
    .. ..- attr(*, "names")= chr [1:24] "GSM42246" "GSM42248" "GSM42252" ...
    ..$ test.data.level : Named num [1:3] 1 1 1
    .. ..- attr(*, "names")= chr [1:3] "GSM42250" "GSM42269" "GSM42270"
    $ :List of 5
    ..$ feature.ids     : int [1:2204] 2064 1016 370 2105 1519 611 997 ...
    ..$ train.data.ids  : chr [1:24] "GSM42246" "GSM42250" "GSM42252" ...
    ..$ test.data.ids   : chr [1:3] "GSM42248" "GSM42249" "GSM42271"
    ..$ train.data.level: Named num [1:24] 1 1 1 1 -1 -1 -1 -1 -1 -1 ...
    .. ..- attr(*, "names")= chr [1:24] "GSM42246" "GSM42250"  ...
    ..$ test.data.level : Named num [1:3] 1 1 1
    .. ..- attr(*, "names")= chr [1:3] "GSM42248" "GSM42249" "GSM42271"
    $ :List of 5
    ..$ feature.ids     : int [1:2204] 2064 370 2032 1446 1174 2105 ...
    ..$ train.data.ids  : chr [1:25] "GSM42246" "GSM42248" ...
    ..$ test.data.ids   : chr [1:2] "GSM42258" "GSM42259"
    ..$ train.data.level: Named num [1:25] 1 1 1 1 1 -1 -1 -1 ...
    .. ..- attr(*, "names")= chr [1:25] "GSM42246" "GSM42248" ...
    ..$ test.data.level : Named num [1:2] 1 1
    .. ..- attr(*, "names")= chr [1:2] "GSM42258" "GSM42259"
    $ :List of 5
    ..$ feature.ids     : int [1:2204] 2064 1913 781 1164 533 370 1914 ...
    ..$ train.data.ids  : chr [1:25] "GSM42246" "GSM42248" "GSM42250" ...
    ..$ test.data.ids   : chr [1:2] "GSM42268" "GSM42247"
    ..$ train.data.level: Named num [1:25] 1 1 1 1 1 -1 -1 -1 ...
    .. ..- attr(*, "names")= chr [1:25] "GSM42246" "GSM42248" ...
    ..$ test.data.level : Named num [1:2] -1 1
    .. ..- attr(*, "names")= chr [1:2] "GSM42268" "GSM42247"
    $ :List of 5
    ..$ feature.ids     : int [1:2204] 2064 1519 625 1996 2032 ...
    ..$ train.data.ids  : chr [1:25] "GSM42246" "GSM42248" ...
    ..$ test.data.ids   : chr [1:2] "GSM42254" "GSM42266"
    ..$ train.data.level: Named num [1:25] 1 1 1 1 -1 -1 -1 -1 -1 -1 ...
    .. ..- attr(*, "names")= chr [1:25] "GSM42246" "GSM42248" ...
    ..$ test.data.level : Named num [1:2] 1 -1
    .. ..- attr(*, "names")= chr [1:2] "GSM42254" "GSM42266"
    }
}

\value{
\item{results }{Return the values stored in the variable.}
}


\source{
https://www.ncbi.nlm.nih.gov/geo/query/acc.cgi?acc=GSE2280
}
\references{
O'Donnell RK, Kupferman M, Wei SJ, Singhal S et al.
Gene expression signature predicts lymphatic metastasis in squamous
cell carcinoma of the oral cavity.
Oncogene 2005 Feb 10;24(7):1244-51. PMID: 15558013
}
\examples{
data(results)
## maybe str(results) ; plot(results) ...
}
\keyword{datasets}
