% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{append2H5}
\alias{append2H5}
\title{Append Matrix to HDF5 File}
\usage{
append2H5(x, h5file, name = "assay", printstatus = TRUE)
}
\arguments{
\item{x}{matrix object to write to an HDF5 file. If the HDF5 file is not 
empty, the exported matrix data needs to have the same number rows as the 
matrix stored in the HDF5 file, and will be appended column-wise to the 
existing one.}

\item{h5file}{character(1), path to existing HDF5 file that can be empty or
contain matrix data}

\item{name}{The name of the dataset in the HDF5 file.}

\item{printstatus}{logical, whether to print status}
}
\value{
HDF5 file storing exported matrix
}
\description{
Function to write matrix data to an existing HDF5 file. If the file contains 
already matrix data then both need to have the same number of rows. The 
append will be column-wise.
}
\examples{
mat <- matrix(1:12, nrow=3)
rownames(mat) <- paste0("r", 1:3); colnames(mat) <- paste0("c", 1:4)
tmp_file <- tempfile(fileext=".h5")
create_empty_h5(tmp_file)
append2H5(mat, tmp_file)
rhdf5::h5ls(tmp_file)
}
