% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UtilityFunctions.R
\name{availableSignatures}
\alias{availableSignatures}
\title{Show Available Signatures}
\usage{
availableSignatures(
  tumor = NULL,
  tissue = NULL,
  topic = NULL,
  requiredInput = NULL,
  description = TRUE
)
}
\arguments{
\item{tumor}{character vector saying the type of tumors for which signatures
are developed. Used to filter the signatures in the table.}

\item{tissue}{character vector saying the type of tissues for which
signatures are developed. Used to filter the signatures in the table.}

\item{topic}{character vector saying the signature topics. Used to filter
the signatures in the table.}

\item{requiredInput}{character string saying the type of data required in
input by the signature. Either one of "microarray", "rnaseq" or "sc". Used to
filter the signatures in the table.}

\item{description}{logical. If TRUE it shows the signature's description.}
}
\value{
A data frame with 12 variables:
\describe{
  \item{signature}{name of the signature}
  \item{scoreLabel}{label of the signature when added inside colData section}
  \item{functionName}{name of the function to use to compute the signature}
  \item{topic}{main cancer topic of the signature}
  \item{tumor}{tumor type for which the signature was developed}
  \item{tissue}{tumor tissue for which the signature was developed}
  \item{cellType}{cell type for which the signature was developed}
  \item{requiredInput}{type of data with which the signature was developed}
  \item{transformationStep}{data transformation step performed inside the
  function starting from the user's 'normArray' or 'normCounts' data}
  \item{author}{first author of the work in which the signature is described}
  \item{reference}{reference of the work}
  \item{description}{signature description and how to evaluate its score}
  ...
}
}
\description{
It returns a table with all the information of the signatures collected
in signifinder.
}
\examples{
availableSignatures()

}
