% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binary_cut.R
\name{plot_binary_cut}
\alias{plot_binary_cut}
\alias{binary_cut}
\title{Cluster functional terms by recursively binary cutting the similarity matrix}
\usage{
plot_binary_cut(
  mat,
  value_fun = area_above_ecdf,
  cutoff = 0.85,
  partition_fun = partition_by_pam,
  dend = NULL,
  dend_width = unit(3, "cm"),
  depth = NULL,
  show_heatmap_legend = TRUE,
  ...
)

binary_cut(
  mat,
  value_fun = area_above_ecdf,
  partition_fun = partition_by_hclust,
  cutoff = 0.85,
  try_all_partition_fun = TRUE,
  partial = nrow(mat) > 1500
)
}
\arguments{
\item{mat}{A similarity matrix.}

\item{value_fun}{A function that calculates the scores for the four submatrices on a node.}

\item{cutoff}{The cutoff for splitting the dendrogram.}

\item{partition_fun}{A function to split each node into two groups. Pre-defined functions
in this package are \code{\link[=partition_by_kmeanspp]{partition_by_kmeanspp()}}, \code{\link[=partition_by_pam]{partition_by_pam()}}  and \code{\link[=partition_by_hclust]{partition_by_hclust()}}.}

\item{dend}{A dendrogram object, used internally.}

\item{dend_width}{Width of the dendrogram on the plot.}

\item{depth}{Depth of the recursive binary cut process.}

\item{show_heatmap_legend}{Whether to show the heatmap legend.}

\item{...}{Other arguments.}

\item{try_all_partition_fun}{Different \code{partition_fun} may give different clusterings. If the vaule
of \code{try_all_partition_fun} is set to \code{TRUE}, the similarity matrix is clustered by three
partitioning method: \code{partition_by_pam()}, \code{partition_by_kmeanspp()} and \code{partition_by_hclust()}.
The clustering with the highest difference score is finally selected as the final clustering.}

\item{partial}{Whether to generate the complete clustering or the clustering stops when sub-matrices
cannot be split anymore.}
}
\value{
\code{binary_cut()} returns a vector of numeric cluster labels.
}
\description{
Cluster functional terms by recursively binary cutting the similarity matrix
}
\details{
After the functions which perform clustering are executed, such as \code{simplifyGO()} or
\code{binary_cut()}, the dendrogram is temporarily saved and \code{plot_binary_cut()} directly
uses this dendrogram.
}
\examples{
\donttest{
mat = readRDS(system.file("extdata", "random_GO_BP_sim_mat.rds", 
    package = "simplifyEnrichment"))
plot_binary_cut(mat, depth = 1)
plot_binary_cut(mat, depth = 2)
plot_binary_cut(mat)
}
mat = readRDS(system.file("extdata", "random_GO_BP_sim_mat.rds",
    package = "simplifyEnrichment"))
binary_cut(mat)
}
