% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/node_partition.R
\name{partition_by_kmeans}
\alias{partition_by_kmeans}
\alias{partition_by_pam}
\alias{partition_by_hclust}
\alias{partition_by_kmeanspp}
\title{Partition the matrix}
\usage{
partition_by_kmeans(mat, n_repeats = 10)

partition_by_pam(mat)

partition_by_hclust(mat)

partition_by_kmeanspp(mat)
}
\arguments{
\item{mat}{The submatrix in the binary cut clustering process.}

\item{n_repeats}{Number of repeated runs of k-means clustering.}
}
\value{
All partitioning functions split the matrix into two groups and return a categorical vector of
labels of 1 and 2.
}
\description{
Partition the matrix
}
\details{
These functions can be set to the \code{partition_fun} argument in \code{\link[=binary_cut]{binary_cut()}}.

\code{partition_by_kmeans()}: Since k-means clustering brings randomness, this function performs
k-means clustering several times (controlled by \code{n_repeats}) and uses the final consensus partitioning results.

\code{partition_by_pam()}: The clustering is performed by \code{\link[cluster:pam]{cluster::pam()}} with the \code{pamonce} argument set to 5.

\code{partition_by_hclust()}: The "ward.D2" clusering method was used.

\code{partition_by_kmeanspp()}: It uses the kmeanspp method from the \strong{flexclust} package.
}
