% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simplify.R
\name{simplifyGO}
\alias{simplifyGO}
\alias{simplifyEnrichment}
\title{Simplify Gene Ontology (GO) enrichment results}
\usage{
simplifyGO(
  mat,
  method = "binary_cut",
  control = list(),
  plot = TRUE,
  verbose = TRUE,
  column_title = qq("@{nrow(mat)} GO terms clustered by '@{method}'"),
  ht_list = NULL,
  ...
)

simplifyEnrichment(...)
}
\arguments{
\item{mat}{A GO similarity matrix. You can also provide a vector of GO IDs to this argument.}

\item{method}{Method for clustering the matrix. See \code{\link[=cluster_terms]{cluster_terms()}}.}

\item{control}{A list of parameters for controlling the clustering method, passed to \code{\link[=cluster_terms]{cluster_terms()}}.}

\item{plot}{Whether to make the heatmap.}

\item{verbose}{Whether to print messages.}

\item{column_title}{Column title for the heatmap.}

\item{ht_list}{A list of additional heatmaps added to the left of the similarity heatmap.}

\item{...}{Arguments passed to \code{\link[=ht_clusters]{ht_clusters()}}.}
}
\value{
A data frame with two columns: GO IDs and cluster labels.
}
\description{
Simplify Gene Ontology (GO) enrichment results
}
\details{
This is basically a wrapper function that it first runs \code{\link[=cluster_terms]{cluster_terms()}} to cluster
GO terms and then runs \code{\link[=ht_clusters]{ht_clusters()}} to visualize the clustering.

The arguments in \code{simplifyGO()} passed to \code{ht_clusters()} are:
\itemize{
\item \code{draw_word_cloud}: Whether to draw the word clouds.
\item \code{min_term}: Minimal number of GO terms in a cluster. All the clusters
with size less than \code{min_term} are all merged into one single cluster in the heatmap.
\item \code{order_by_size}: Whether to reorder GO clusters by their sizes. The cluster
that is merged from small clusters (size < \code{min_term}) is always put to the bottom of the heatmap.
\item \code{stat}: What values of keywords are used to map to font sizes in the word clouds.
\item \code{exclude_words}: Words that are excluded in the word cloud.
\item \code{max_words}: Maximal number of words visualized in the word cloud.
\item \code{word_cloud_grob_param}: A list of graphic parameters passed to \code{\link[=word_cloud_grob]{word_cloud_grob()}}.
\item \code{fontsize_range} The range of the font size. The value should be a numeric vector with length two.
The minimal font size is mapped to word frequency value of 1 and the maximal font size is mapped
to the maximal word frequency. The font size interlopation is linear.
\item \code{bg_gp}: Graphic parameters for controlling the background of word cloud annotations.
}
}
\examples{
\donttest{
set.seed(123)
go_id = random_GO(500)
mat = GO_similarity(go_id)
df = simplifyGO(mat, word_cloud_grob_param = list(max_width = 80))
head(df)
}
}
