% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/importGeneSets.R
\name{importGeneSetsFromMSigDB}
\alias{importGeneSetsFromMSigDB}
\title{Imports gene sets from MSigDB}
\usage{
importGeneSetsFromMSigDB(
  inSCE,
  categoryIDs = "H",
  species = "Homo sapiens",
  mapping = c("gene_symbol", "human_gene_symbol", "entrez_gene"),
  by = "rownames",
  verbose = TRUE,
  noMatchError = TRUE
)
}
\arguments{
\item{inSCE}{Input \linkS4class{SingleCellExperiment} object.}

\item{categoryIDs}{Character vector containing the MSigDB gene set ids.
The column \code{ID} in the table returned by \code{getMSigDBTable()} shows
the list of possible gene set IDs that can be obtained.
Default is \code{"H"}.}

\item{species}{Character. Species available can be found using the function
\code{\link[msigdbr]{msigdbr_species}}. Default \code{"Homo sapiens"}.}

\item{mapping}{Character. One of "gene_symbol", "human_gene_symbol", or
"entrez_gene". Gene identifiers to be used for MSigDB gene sets. IDs
denoted by the \code{by} parameter must be either in gene symbol or
Entrez gene id format to match IDs from MSigDB.}

\item{by}{Character. Describes the
location within \code{inSCE} where the gene identifiers in
the MSigDB gene sets should be mapped. If set to \code{"rownames"} then the
features will be searched for among \code{rownames(inSCE)}. This can also be
set to one of the column names of \code{rowData(inSCE)} in which case the
gene identifies will be mapped to that column in the \code{rowData}
of \code{inSCE}. See \link{featureIndex} for more information.
Default \code{"rownames"}.}

\item{verbose}{Boolean. Whether to display progress. Default \code{TRUE}.}

\item{noMatchError}{Boolean. Show an error if a collection does not have
any matching features. Default \code{TRUE}.}
}
\value{
A \link[SingleCellExperiment]{SingleCellExperiment} object
with gene set from \code{collectionName} output stored to the
\link{metadata} slot.
}
\description{
Gets a list of MSigDB gene sets stores it in the metadata of the
\linkS4class{SingleCellExperiment} object. These gene sets can be used in
downstream quality control and analysis functions in \link{singleCellTK}.
}
\details{
The gene identifiers in gene sets from MSigDB will be retrieved
using the \code{\link{msigdbr}} package. They will be mapped to the IDs in
\code{inSCE} using the \code{by} parameter and
stored in a \linkS4class{GeneSetCollection} object from package
\link{GSEABase}. This object is stored in
\code{metadata(inSCE)$sctk$genesets}, which can be accessed in downstream
analysis functions such as \link[singleCellTK]{runCellQC}.
}
\examples{
data(scExample)
sce <- importGeneSetsFromMSigDB(inSCE = sce,
                                categoryIDs = "H",
                                species = "Homo sapiens",
                                mapping = "gene_symbol",
                                by = "feature_name")
}
\seealso{
\link{importGeneSetsFromList} for importing from lists,
\link{importGeneSetsFromGMT} for importing from GMT files, and
\linkS4class{GeneSetCollection} objects.
}
\author{
Joshua D. Campbell
}
