% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seuratFunctions.R
\name{plotSeuratGenes}
\alias{plotSeuratGenes}
\title{Compute and plot visualizations for marker genes}
\usage{
plotSeuratGenes(
  inSCE,
  useAssay = "seuratNormData",
  plotType,
  features,
  groupVariable = NULL,
  reducedDimName = "seuratUMAP",
  splitBy = NULL,
  cols = c("lightgrey", "blue"),
  ncol = 1,
  combine = FALSE
)
}
\arguments{
\item{inSCE}{Input \code{SingleCellExperiment} object.}

\item{useAssay}{Specify the name of the assay that will be scaled by this
function.}

\item{plotType}{Specify the type of the plot to compute. Options are limited
to "ridge", "violin", "feature", "dot" and "heatmap".}

\item{features}{Specify the features to compute the plot against.}

\item{groupVariable}{Specify the column name from the colData slot that
should be used as grouping variable.
 Default is \code{NULL}.}

\item{reducedDimName}{saved dimension reduction name in the
SingleCellExperiment object. Default \code{seuratUMAP}.}

\item{splitBy}{Specify the column name from the colData slot that should be
used to split samples.
 Default is \code{NULL}.}

\item{cols}{Specify two colors to form a gradient between. Default is
\code{c("lightgrey", "blue")}.}

\item{ncol}{Visualizations will be adjusted in "ncol" number of columns.
Default is \code{1}.}

\item{combine}{A logical value that indicates if the plots should be combined
together into a single plot if \code{TRUE}, else if \code{FALSE} returns
separate ggplot objects for each feature. Only works when \code{plotType}
parameter is \code{"feature"}, \code{"violin"} or \code{"ridge"}. For
\code{"heatmap"} and \code{"dot"}, plots for all features are always
combined into a single plot. Default \code{FALSE}.}
}
\value{
Plot object
}
\description{
Compute and plot visualizations for marker genes
}
