% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scanpyFunctions.R
\name{runScanpyFindHVG}
\alias{runScanpyFindHVG}
\title{runScanpyFindHVG
Find highly variable genes and store in the input sce object}
\usage{
runScanpyFindHVG(
  inSCE,
  useAssay = "scanpyNormData",
  method = c("seurat", "cell_ranger", "seurat_v3"),
  altExpName = "featureSubset",
  altExp = FALSE,
  hvgNumber = 2000,
  minMean = 0.0125,
  maxMean = 3,
  minDisp = 0.5,
  maxDisp = Inf
)
}
\arguments{
\item{inSCE}{(sce) object to compute highly variable genes from and to store
back to it}

\item{useAssay}{Specify the name of the assay to use for computation
of variable genes. It is recommended to use log normalized data, except when 
flavor='seurat_v3', in which counts data is expected.}

\item{method}{selected method to use for computation of highly variable
genes. One of \code{'seurat'}, \code{'cell_ranger'}, or \code{'seurat_v3'}.
Default \code{"seurat"}.}

\item{altExpName}{Character. Name of the alternative experiment object to
add if \code{returnAsAltExp = TRUE}. Default \code{featureSubset}.}

\item{altExp}{Logical value indicating if the input object is an
altExperiment. Default \code{FALSE}.}

\item{hvgNumber}{numeric value of how many genes to select as highly
variable. Default \code{2000}}

\item{minMean}{If n_top_genes unequals None, this and all other cutoffs for 
the means and the normalized dispersions are ignored. Ignored if 
flavor='seurat_v3'. Default \code{0.0125}}

\item{maxMean}{If n_top_genes unequals None, this and all other cutoffs for 
the means and the normalized dispersions are ignored. Ignored if 
flavor='seurat_v3'. Default \code{3}}

\item{minDisp}{If n_top_genes unequals None, this and all other cutoffs for 
the means and the normalized dispersions are ignored. Ignored if 
flavor='seurat_v3'. Default \code{0.5}}

\item{maxDisp}{If n_top_genes unequals None, this and all other cutoffs for 
the means and the normalized dispersions are ignored. Ignored if 
flavor='seurat_v3'. Default \code{Inf}}
}
\value{
Updated \code{SingleCellExperiment} object with highly variable genes
computation stored
\code{\link{getTopHVG}}, \code{\link{plotTopHVG}}
}
\description{
runScanpyFindHVG
Find highly variable genes and store in the input sce object
}
\examples{
data(scExample, package = "singleCellTK")
\dontrun{
sce <- runScanpyNormalizeData(sce, useAssay = "counts")
sce <- runScanpyFindHVG(sce, useAssay = "scanpyNormData", method = "seurat")
g <- getTopHVG(sce, method = "seurat", hvgNumber = 500)
}
}
