% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/higher_level_functions.R
\name{tissue_specificity}
\alias{tissue_specificity}
\title{Tissue Specificity (TS): produces a list of samples with their tissues
marked which either contain queried junctions (1) or not (0); can be used
as input to significance testing methods such as Kruskal-Wallis to look for
tissue enrichment (currently only works for the GTEx compilation).}
\usage{
tissue_specificity(..., group_names = NULL)
}
\arguments{
\item{...}{One or more QueryBuilder objects}

\item{group_names}{Optional vector of strings representing the
group names}
}
\value{
A DataFrame of all samples in the compilation with either a
0 or 1 indicating their occurrence and shared status (if > 1
group passed in).  Occurrence here is if the sample has at least
one result with > 0 coverage, and further, if > 1 group is passed
in, then if it occurs in the results of all groups.  Also includes the
sample tissue type and sample_id.
}
\description{
Lists the number of samples labeled with a specific tissue type.
Samples are filtered for ones which have junctions across all the
user-specified groups. That is, if a sample only appears in the results of
some of the groups (from their basic queries) it will be assigned a 0,
otherwise if it is in all of the groups' results it will be assigned a 1.
This is similar to the SSC high level query type, but doesn't sum the
coverage.
}
\details{
The samples are then grouped by their tissue type (e.g. Brain).
This is useful for determining if there's an enrichment for a specific
tissue in the set of junctions queried.  Results from this can be fed to a
statistical test, such as the Kruskal-wallis non-parametric rank test.
This query is limited to GTEx only, due to the fact that GTEx is one of the
few compilations that has consistent and complete tissue metadata.
}
\examples{
in1 <- QueryBuilder(compilation = "gtex", regions = "chr4:20763023-20763023")
in1 <- set_coordinate_modifier(in1, Coordinates$EndIsExactOrWithin)
in1 <- set_row_filters(in1, strand == "-")

in2 <- QueryBuilder(compilation = "gtex", regions = "chr4:20763098-20763098")
in2 <- set_coordinate_modifier(in2, Coordinates$StartIsExactOrWithin)
in2 <- set_row_filters(in2, strand == "-")

tissue_specificity(list(in1, in2))
}
