% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GeneSetDb-methods.R
\name{hasGeneSet}
\alias{hasGeneSet}
\title{Check to see if the GeneSetDb has a collection,name GeneSet defined}
\usage{
hasGeneSet(x, collection, name, as.error = FALSE)
}
\arguments{
\item{x}{GeneSetDb}

\item{collection}{character indicating the collection}

\item{name}{character indicating the name of the geneset}

\item{as.error}{If \code{TRUE}, a test for the existance of the geneset will throw
an error if the geneset does not exist}
}
\value{
logical indicating whether or not the geneset is defined.
}
\description{
Check to see if the GeneSetDb has a collection,name GeneSet defined
}
\examples{
gdb <- exampleGeneSetDb()
hasGeneSet(gdb, c('c2', 'c7'), c('BIOCARTA_AGPCR_PATHWAY', 'something'))
}
