#' Mouse Olfactory Bulb spatial gene expression data
#'
#' Replicate 11 from the spatially dependent gene expression data from the mouse
#' olfactory bulb generated by Stahl et al. (2016).
#' This data was originally downloaded from
#' <https://github.com/Teichlab/SpatialDE/blob/master/Analysis/MouseOB/data/Rep11_MOB_0.csv>.
#'
#' @format A matrix with 16218 genes as rows and 262 spots as columns.
#' @usage data(Rep11_MOB_0)
#'
#' @references
#' Ståhl, P. L. et al. (2016) 'Visualization and analysis of gene expression in
#' tissue sections by spatial transcriptomics', \emph{Science}, 353(6294), p.
#' 78. doi: 10.1126/science.aaf2403.
"Rep11_MOB_0"

#' Mouse Olfactory Bulb sample metadata
#'
#' Coordinates and total counts for the samples from the Mouse Olfactory Bulb
#' data generated by Stahl et al. (2016).
#' This data was originally downloaded from
#' <https://github.com/Teichlab/SpatialDE/blob/master/Analysis/MouseOB/MOB_sample_info.csv>.
#'
#' @format A `data.frame` with 262 rows and 3 variables as columns: the `x` and
#'   `y` coordinates and `total_counts` corresponding to each spot.
#'
#' @usage data(MOB_sample_info)
#' @references
#' Ståhl, P. L. et al. (2016) 'Visualization and analysis of gene expression in
#' tissue sections by spatial transcriptomics', \emph{Science}, 353(6294), p.
#' 78. doi: 10.1126/science.aaf2403.
"MOB_sample_info"
