\name{read.bibliospec}

\alias{read.bibliospec}
\alias{bibliospec}
\alias{BiblioSpec}
\alias{skyline}
\alias{Skyline}

\alias{plot.psm}

\alias{plot.psmSet}

\alias{summary.psmSet}

\title{BiblioSpec Reader}

\description{

    This function reads a BiblioSpec generated file and returns 
    a list of tandem mass specs (psm objects), 
    peptide assignments, retention times, and 
    modifications records. The type of the data structire which is 
    returned is called psmSet.
    
}

\usage{

    read.bibliospec(file)
}

\arguments{

  \item{file}{the name of the BiblioSpec generated SQLite file.}
}

\details{

    The function performs a SQL query on the SQLite files generated by 
    bibliospec using the \code{RSQLite} package.
    The function is required for generating spec libraries used
    in a SWATH workflow.

    BiblioSpec files are generated by using Skyline.
    

}

\seealso{

  \url{https://skyline.gs.washington.edu/labkey/project/home/software/Skyline/begin.view}

  \url{https://skyline.gs.washington.edu/labkey/project/home/software/BiblioSpec/begin.view}
    
  \url{http://www.sqlite.org/}
  
  \code{?SQLite}
  
}

\value{

    It returns a list which can be read by the \code{genSwathIonLib} 
    function and the \code{protViz::peakplot} function.

}

\author{

   Christian Panse, 2014, 2015

}

\examples{

    read.bibliospec
}
