% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bam_to_bins.R
\name{bam_to_bins}
\alias{bam_to_bins}
\title{create a tiled representation of a genome from the BAM/CRAM file}
\usage{
bam_to_bins(x, width = 300, param = NULL, which = IRangesList(), ...)
}
\arguments{
\item{x}{a BAM or CRAM filename (or a BamFile object)}

\item{width}{the width of the bins to tile (default is 300)}

\item{param}{optional ScanBamParam (whence we attempt to extract \code{which})}

\item{which}{an optional GRanges restricting the bins to certain locations}

\item{...}{additional arguments to pass on to seqinfo_from_header}
}
\value{
\if{html}{\out{<div class="sourceCode">}}\preformatted{   a GRangesList with y-base-pair-wide bins tiled across it
}\if{html}{\out{</div>}}
}
\description{
This function replaces a bedtools call:
bedtools intersect -wao -a fragments.bed -b hg38_300bp_windows.bed > data.bed
}
\details{
The idea is to skip the BED creation step for most runs, and just do it once.
In order to count reads in bins, we need bins.
In order to have bins, we need to know how long the chromosomes are.
In order to have a BAM or CRAM file, we need to have those same lengths.
This function takes advantage of all of the above to create binned ranges.
Note that a very recent branch of Rsamtools is required for CRAM file bins.
}
\examples{
library(Rsamtools) 
fl <- system.file("extdata", "ex1.bam", package="Rsamtools", mustWork=TRUE)
bam_to_bins(fl) 

}
\seealso{
seqinfo_from_header
}
