% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kmers.R
\name{kmers}
\alias{kmers}
\title{oligonucleotideFrequency, but less letters and more convenient.}
\usage{
kmers(x, k = 6)
}
\arguments{
\item{x}{BSgenome, DFrame with \code{sequence} column, or DNAStringSet}

\item{k}{the length of the kmers (default is 6)}
}
\value{
\if{html}{\out{<div class="sourceCode">}}\preformatted{       a matrix of contigs (rows) by kmer frequencies (columns)
}\if{html}{\out{</div>}}
}
\description{
oligonucleotideFrequency, but less letters and more convenient.
}
\details{
The companion \code{kmax} function finds the maximum frequency kmer for each
contig and plots all of them together for comparison purposes.
}
\examples{

data(genbank_mito, package="spiky") 
mtk6 <- kmers(genbank_mito, k=6)
kmax(mtk6)

data(phage, package="spiky") 
phk6 <- kmers(phage, k=6)
kmax(phk6)

}
\seealso{
\if{html}{\out{<div class="sourceCode">}}\preformatted{      kmax
}\if{html}{\out{</div>}}
}
