% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SCE-functions.R
\name{addGeneLengths}
\alias{addGeneLengths}
\title{Add gene lengths}
\usage{
addGeneLengths(
  sce,
  method = c("generate", "sample"),
  loc = 7.9,
  scale = 0.7,
  lengths = NULL
)
}
\arguments{
\item{sce}{SingleCellExperiment to add gene lengths to.}

\item{method}{Method to use for creating lengths.}

\item{loc}{Location parameter for the generate method.}

\item{scale}{Scale parameter for the generate method.}

\item{lengths}{Vector of lengths for the sample method.}
}
\value{
SingleCellExperiment with added gene lengths
}
\description{
Add gene lengths to an SingleCellExperiment object
}
\details{
This function adds simulated gene lengths to the
\code{\link[SummarizedExperiment]{rowData}} slot of a
\code{\link[SingleCellExperiment]{SingleCellExperiment}} object that can be
used for calculating length normalised expression values such as TPM or FPKM.
The \code{generate} method simulates lengths using a (rounded) log-normal
distribution, with the default \code{loc} and \code{scale} parameters based
on human protein-coding genes. Alternatively the \code{sample} method can be
used which randomly samples lengths (with replacement) from a supplied
vector.
}
\examples{
# Default generate method
sce <- simpleSimulate()
sce <- addGeneLengths(sce)
head(rowData(sce))
# Sample method (human coding genes)
\dontrun{
library(TxDb.Hsapiens.UCSC.hg19.knownGene)
library(GenomicFeatures)
txdb <- TxDb.Hsapiens.UCSC.hg19.knownGene
tx.lens <- transcriptLengths(txdb, with.cds_len = TRUE)
tx.lens <- tx.lens[tx.lens$cds_len > 0, ]
gene.lens <- max(splitAsList(tx.lens$tx_len, tx.lens$gene_id))
sce <- addGeneLengths(sce, method = "sample", lengths = gene.lens)
}

}
