% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kersplat-estimate.R
\name{kersplatEstMean}
\alias{kersplatEstMean}
\title{Estimate Kersplat means}
\usage{
kersplatEstMean(norm.counts, params, verbose)
}
\arguments{
\item{norm.counts}{library size normalised counts matrix.}

\item{params}{KersplatParams object to store estimated values in.}

\item{verbose}{logical. Whether to print progress messages}
}
\value{
KersplatParams object with estimated means
}
\description{
Estimate mean parameters for the Kersplat simulation
}
\details{
Parameters for the gamma distribution are estimated by fitting the mean
normalised counts using \code{\link[fitdistrplus]{fitdist}}. All the fitting
methods are tried and the fit with the best Cramer-von Mises statistic is
selected. The density of the means is also estimated using
\code{\link[stats]{density}}.

Expression outlier genes are detected using the Median Absolute Deviation
(MAD) from median method. If the log2 mean expression of a gene is greater
than two MADs above the median log2 mean expression it is designated as an
outlier. The proportion of outlier genes is used to estimate the outlier
probability. Factors for each outlier gene are calculated by dividing mean
expression by the median mean expression. A log-normal distribution is then
fitted to these factors in order to estimate the outlier factor location and
scale parameters using the \code{\link[fitdistrplus]{fitdist}} MLE method.
}
\keyword{internal}
