% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lun-estimate.R
\name{lunEstimate}
\alias{lunEstimate}
\alias{lunEstimate.SingleCellExperiment}
\alias{lunEstimate.matrix}
\title{Estimate Lun simulation parameters}
\usage{
lunEstimate(counts, params = newLunParams())

\method{lunEstimate}{SingleCellExperiment}(counts, params = newLunParams())

\method{lunEstimate}{matrix}(counts, params = newLunParams())
}
\arguments{
\item{counts}{either a counts matrix or an SingleCellExperiment object
containing count data to estimate parameters from.}

\item{params}{LunParams object to store estimated values in.}
}
\value{
LunParams object containing the estimated parameters.
}
\description{
Estimate simulation parameters for the Lun simulation from a real dataset.
}
\details{
The \code{nGenes} and \code{nCells} parameters are taken from the size of the
input data. No other parameters are estimated. See \code{\link{LunParams}}
for more details on the parameters.
}
\examples{
# Load example data
library(scuttle)
set.seed(1)
sce <- mockSCE()

params <- lunEstimate(sce)
params
}
