% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scDD-estimate.R
\name{scDDEstimate}
\alias{scDDEstimate}
\alias{scDDEstimate.matrix}
\alias{scDDEstimate.SingleCellExperiment}
\alias{scDDEstimate.default}
\title{Estimate scDD simulation parameters}
\usage{
scDDEstimate(
  counts,
  params = newSCDDParams(),
  verbose = TRUE,
  BPPARAM = SerialParam(),
  ...
)

\method{scDDEstimate}{matrix}(
  counts,
  params = newSCDDParams(),
  verbose = TRUE,
  BPPARAM = SerialParam(),
  conditions,
  ...
)

\method{scDDEstimate}{SingleCellExperiment}(
  counts,
  params = newSCDDParams(),
  verbose = TRUE,
  BPPARAM = SerialParam(),
  condition = "condition",
  ...
)

\method{scDDEstimate}{default}(
  counts,
  params = newSCDDParams(),
  verbose = TRUE,
  BPPARAM = SerialParam(),
  condition,
  ...
)
}
\arguments{
\item{counts}{either a counts matrix or a SingleCellExperiment object
containing count data to estimate parameters from.}

\item{params}{SCDDParams object to store estimated values in.}

\item{verbose}{logical. Whether to show progress messages.}

\item{BPPARAM}{A \code{\link[BiocParallel]{BiocParallelParam}} instance
giving the parallel back-end to be used. Default is
\code{\link[BiocParallel]{SerialParam}} which uses a single core.}

\item{...}{further arguments passed to or from other methods.}

\item{conditions}{Vector giving the condition that each cell belongs to.
Conditions can be 1 or 2.}

\item{condition}{String giving the column that represents biological group of
interest.}
}
\value{
SCDDParams object containing the estimated parameters.
}
\description{
Estimate simulation parameters for the scDD simulation from a real dataset.
}
\details{
This function applies \code{\link[scDD]{preprocess}} to the counts then uses
\code{\link[scDD]{scDD}} to estimate the numbers of each gene type to
simulate. The output is then converted to a SCDDParams object. See
\code{\link[scDD]{preprocess}} and \code{\link[scDD]{scDD}} for details.
}
\examples{
if (requireNamespace("scDD", quietly = TRUE)) {
    library(scuttle)
    set.seed(1)
    sce <- mockSCE(ncells = 20, ngenes = 100)

    colData(sce)$condition <- sample(1:2, ncol(sce), replace = TRUE)
    params <- scDDEstimate(sce, condition = "condition")
    params
}

}
