% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/splatPop-estimate.R
\name{splatPopEstimate}
\alias{splatPopEstimate}
\title{Estimate population/eQTL simulation parameters}
\usage{
splatPopEstimate(
  counts = NULL,
  means = NULL,
  eqtl = NULL,
  params = newSplatPopParams()
)
}
\arguments{
\item{counts}{either a counts matrix or a SingleCellExperiment object
containing count data to estimate parameters from.}

\item{means}{Matrix of real gene means across a population, where
each row is a gene and each column is an individual in the population.}

\item{eqtl}{data.frame with all or top eQTL pairs from a real eQTL analysis.
Must include columns: 'gene_id', 'pval_nominal', and 'slope'.}

\item{params}{SplatPopParams object containing parameters for the
simulation of the mean expression levels for the population.
See \code{\link{SplatPopParams}} for details.}
}
\value{
SplatPopParams object containing the estimated parameters.
}
\description{
Estimate simulation parameters for the eQTL population simulation from
real data. See the individual estimation functions for more details on
how this is done.
}
\examples{

if (requireNamespace("VariantAnnotation", quietly = TRUE) &&
    requireNamespace("preprocessCore", quietly = TRUE)) {
    # Load example data
    library(scuttle)

    sce <- mockSCE()
    params <- splatPopEstimate(sce)
}

}
\seealso{
\code{\link{splatPopEstimateEffectSize}},
\code{\link{splatPopEstimateMeanCV}}
}
