context("Params")

test_that("setParam sets correctly", {
    params <- newSimpleParams()
    params <- setParam(params, "nGenes", 100)
    expect_equal(getParam(params, "nGenes"), 100)
    params <- setParam(params, "mean.rate", 0.5)
    expect_equal(getParam(params, "mean.rate"), 0.5)
})

test_that("getParam gets correctly", {
    params <- newSimpleParams()
    expect_equal(getParam(params, "nGenes"), 10000)
    expect_equal(getParam(params, "mean.rate"), 0.3)
})

test_that("set.seed() works for Params()", {
    ## newSimpleParams()
    set.seed(1)
    params1 <- newSimpleParams()
    set.seed(2)
    params2 <- newSimpleParams()
    expect_true(getParam(params1, "seed") != getParam(params2, "seed"))
    set.seed(1)
    params3 <- newSimpleParams()
    expect_equal(params1, params3)
    params4 <- newSimpleParams(seed = getParam(params2, "seed"))
    expect_equal(params2, params4)
    ## newLunParams()
    set.seed(1)
    params1 <- newLunParams()
    set.seed(2)
    params2 <- newLunParams()
    expect_true(getParam(params1, "seed") != getParam(params2, "seed"))
    set.seed(1)
    params3 <- newLunParams()
    expect_equal(params1, params3)
    params4 <- newLunParams(seed = getParam(params2, "seed"))
    expect_equal(params2, params4)
})
