% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helperFunctions.R
\name{makeXcmsObjFlat}
\alias{makeXcmsObjFlat}
\title{Make an XCMS object flat}
\usage{
makeXcmsObjFlat(xcms_obj, revert_rts = TRUE, verbosity = 0)
}
\arguments{
\item{xcms_obj}{A XCMSnExp object produced by the typical XCMS workflow which
should include retention time correction and peak correspondence and filling}

\item{revert_rts}{Scalar boolean controlling whether the adjusted retention
times found in the XCMS object are propagated or returned as-is}

\item{verbosity}{Scalar numberic. Will report XCMS info if greater than zero
or run silently if not (the default).}
}
\value{
A data.frame with columns for feature information (from
featureDefinitions: feature, feat_mzmed, feat_rtmed, feat_npeaks, and
peakidx) and peak information (from chromPeaks: mz, mzmin, mzmax, rt, rtmin,
rtmax, into, intb, maxo, sn, sample) as well as the full path to the
associated file and the file name alone (filepath and filename).
}
\description{
XCMSnExp objects are complicated S4 objects that make
it difficult to access information about the features and their associated
peaks. This function turns the output into a "flat" file format (a
data.frame) so it can interact with tidyverse functions more easily.
}
\examples{
library(xcms)
library(dplyr)
library(MSnbase)
mzML_files <- system.file("extdata", package = "RaMS") \%>\%
    list.files(full.names = TRUE, pattern = "[A-F].mzML")
register(BPPARAM = SerialParam())
cwp <- CentWaveParam(snthresh = 0, extendLengthMSW = TRUE, integrate = 2)
obp <- ObiwarpParam(binSize = 0.1, response = 1, distFun = "cor_opt")
pdp <- PeakDensityParam(
    sampleGroups = 1:3, bw = 12, minFraction = 0,
    binSize = 0.001, minSamples = 0
)
xcms_filled <- mzML_files \%>\%
    readMSData(msLevel. = 1, mode = "onDisk") \%>\%
    findChromPeaks(cwp) \%>\%
    adjustRtime(obp) \%>\%
    groupChromPeaks(pdp) \%>\%
    fillChromPeaks(FillChromPeaksParam(ppm = 5))
makeXcmsObjFlat(xcms_filled)
}
