% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readAnnot.R
\name{readAnnotation}
\alias{readAnnotation}
\title{Reads and parses GFF/GTF files}
\usage{
readAnnotation(fileName, feature = NULL, source = NULL, tagName = NULL)
}
\arguments{
\item{fileName}{A path, URL or connection to the GFF/GTF annotation
file. Compressed files (\code{"gz"}, \code{"bz2"} and
\code{"xz"}) are handled transparently.}

\item{feature}{\code{NULL} (the default) or a character vector of valid
feature types. If not \code{NULL}, then only the features
of the specified type(s) are imported.}

\item{source}{\code{NULL} (the default) or a character vector of valid
source types. If not \code{NULL}, then only the sources
of the specified type(s) are imported.}

\item{tagName}{\code{NULL} (the default). If not \code{NULL}, use this tag
as systematic name for the elements of the \code{GRanges}
object.}
}
\value{
A \code{GRanges} object with annotated regions information.
}
\description{
\code{readAnnotation} reads and parses content of GFF/GTF files
and stores annotated genomic features (regions) in a \code{GRanges}
object.
}
\details{
\code{feature} and \code{source} can be \code{NULL}. In this case, no
selection is performed and all content into the file is imported.
If \code{tagName} is \code{NULL}, then a systematic name
(\code{annot.N}) is given to elements of the \code{GRanges} object.
}
\examples{
##-----------------------------------------------------------------------
## Extraction of miRNAs using an GTF annotation file
##-----------------------------------------------------------------------
basedir  <- system.file("extdata", package="srnadiff", mustWork = TRUE)
gtfFile  <- file.path(basedir, "Homo_sapiens.GRCh38.76.gtf.gz")
annotReg <- readAnnotation(gtfFile, feature="gene", source="miRNA")
annotReg

##-----------------------------------------------------------------------
## Extraction of mature miRNAs using a miRBase-formatted file
##-----------------------------------------------------------------------
basedir  <- system.file("extdata", package="srnadiff", mustWork = TRUE)
gffFile  <- file.path(basedir, "mirbase21_GRCh38.gff3")
annotReg <- readAnnotation(gffFile, feature="miRNA", tagName="miRNA")
annotReg

##-----------------------------------------------------------------------
## Extraction of precursor miRNAs using a miRBase-formatted file
##-----------------------------------------------------------------------
basedir  <- system.file("extdata", package="srnadiff", mustWork = TRUE)
gffFile  <- file.path(basedir, "mirbase21_GRCh38.gff3")
annotReg <- readAnnotation(gffFile, feature="miRNA_primary_transcript")
annotReg

}
\seealso{
\code{\link[rtracklayer]{GFFFile-class}}
}
