% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allGenerics.R, R/accessors.R
\docType{methods}
\name{getPScreen}
\alias{getPScreen}
\alias{getPScreen}
\alias{getPScreen,stageR}
\alias{getPScreen,stageRTx}
\alias{getPScreen,stageRTx-method}
\title{Return screening hypothesis p-values from a \code{\link{stageRClass}} object.}
\usage{
getPScreen(object, ...)

\S4method{getPScreen}{stageR}(object)

\S4method{getPScreen}{stageRTx}(object)
}
\arguments{
\item{object}{an object of the \code{\link{stageRClass}} class.}

\item{...}{Additional arguments}
}
\value{
A vector of screening stage (aggregated) p-values.
}
\description{
Return screening hypothesis p-values from a \code{\link{stageRClass}} object.
}
\section{Methods (by class)}{
\itemize{
\item \code{stageRTx}: Return screening hypothesis p-values from a \code{\link{stageRClass}} object.
}}

\examples{
pScreen=c(seq(1e-10,1e-2,length.out=100),seq(1e-2,.2,length.out=100),seq(.2,1,length.out=100))
names(pScreen)=paste0("gene",1:300)
pConfirmation=matrix(runif(900),nrow=300,ncol=3)
dimnames(pConfirmation)=list(paste0("gene",1:300),c("H1","H2","H3"))
stageRObj <- stageR(pScreen=pScreen, pConfirmation=pConfirmation)
getPScreen(stageRObj)
}
