% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepareDecon.R
\name{prepareSpatialDecon}
\alias{prepareSpatialDecon}
\title{Preparing the inputs for SpatialDecon for doing deconvolution on spatial data}
\usage{
prepareSpatialDecon(
  spe,
  assay2use = "logcounts",
  negProbeName = "NegProbe-WTX",
  pool = NA
)
}
\arguments{
\item{spe}{SpatialExperiment object.}

\item{assay2use}{The name of the assay to use. By default is logcounts.}

\item{negProbeName}{The name of the negative probe gene. By default is NegProbe-WTX.}

\item{pool}{A vector indicates the pools of the genes. This is required when there are more than one Negative Probes.}
}
\value{
A list of two dataframes. The first data.frame is the normalised count, the second data.frame is the background for the data.
}
\description{
Preparing the inputs for SpatialDecon for doing deconvolution on spatial data
}
\examples{
library(ExperimentHub)
eh <- ExperimentHub()

query(eh, "standR")
countFile <- eh[["EH7364"]]
sampleAnnoFile <- eh[["EH7365"]]

spe <- readGeoMx(countFile, sampleAnnoFile, rmNegProbe = FALSE)

out <- prepareSpatialDecon(spe)

}
