% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/03_similarity_searches.R
\name{export_sequences}
\alias{export_sequences}
\title{Export processed sequences as FASTA files}
\usage{
export_sequences(seq = NULL, outdir = tempdir())
}
\arguments{
\item{seq}{A processed list of AAStringSet objects
as returned by \code{process_input()}.}

\item{outdir}{Path to output directory where FASTA files will be stored.}
}
\value{
Path to exported FASTA files.
}
\description{
Export processed sequences as FASTA files
}
\examples{
# Load data
data(proteomes)
data(annotation)

# Process data
pdata <- process_input(proteomes, annotation)

# Export data
outdir <- file.path(tempdir(), "example_test")
export_sequences(pdata$seq, outdir)
}
