% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/assignFeatureDar.R
\name{assignFeatureDar}
\alias{assignFeatureDar}
\alias{assignFeatureDar,GRangesList,GRanges-method}
\title{Assign DAR values to genomic features}
\usage{
assignFeatureDar(
  dar,
  features,
  dar_val = c("origin", "region"),
  fill_missing = NA
)

\S4method{assignFeatureDar}{GRangesList,GRanges}(
  dar,
  features,
  dar_val = c("origin", "region"),
  fill_missing = NA
)
}
\arguments{
\item{dar}{\code{GRangesList} with DAR values of the associated ranges contained
in metadata columns.
Ranges that represent DAR regions are recommended to assign the greatest
number of features with DAR values.
This results in an assigned estimate of DAR in the region surrounding the
feature.
Alternatively, the use of DAR origin ranges results in an assigned average
of DAR solely within the feature.
Ranges can be converted between origins and regions with
\link{flipRanges}.}

\item{features}{\code{GRanges} object specifying the features of interest.}

\item{dar_val}{Deprecated.
\code{character(1)} specifying the whether to use origin or region DAR values
for the chosen ranges.
Please use the default "origin" to avoid averaging already averaged
values.}

\item{fill_missing}{The DAR value to assign features with no overlaps.
Defaults to \code{NA}.}
}
\value{
\code{GRangesList} with ranges representing features of interest that
overlap at least one DAR range.
Feature metadata columns are retained and an additional column is added
for the assigned DAR value.
}
\description{
Assign DAR values to genomic features of interest by
averaging the DAR values of ranges that overlap the feature range.
}
\examples{
data("chr1_genes")
fl <- system.file("extdata", "chr1.vcf.bgz", package="tadar")
genotypes <- readGenotypes(fl)
groups <- list(
    group1 = paste0("sample", 1:6),
    group2 = paste0("sample", 7:13)
)
counts <- countAlleles(genotypes, groups)
counts_filt <- filterLoci(counts)
props <- countsToProps(counts_filt)
contrasts <- matrix(
    data = c(1, -1),
    dimnames = list(
        Levels = c("group1", "group2"),
        Contrasts = c("group1v2")
    )
)
dar <- dar(props, contrasts, region_loci = 5)
assignFeatureDar(dar, chr1_genes)

dar_regions <- flipRanges(dar, extend_edges = TRUE)
assignFeatureDar(dar_regions, chr1_genes)

}
