% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/flipRanges.R
\name{flipRanges}
\alias{flipRanges}
\alias{flipRanges,GRangesList-method}
\title{Convert DAR origin ranges to DAR region ranges, or vice versa}
\usage{
flipRanges(dar, extend_edges = FALSE)

\S4method{flipRanges}{GRangesList}(dar, extend_edges = FALSE)
}
\arguments{
\item{dar}{\code{GRangesList} with ranges representing single nucleotide (origin)
positions.}

\item{extend_edges}{\code{logical(1)} specifying if region DAR ranges at the edges
of each chromosome should be extended to cover the entire chromosome
when converting from origin ranges to region ranges.
This argument is only considered if \code{region_loci} was used to construct
regions in the \code{\link[=dar]{dar()}} function.
Useful for downstream assignment of DAR values to genomic features that
exist at the 5' or 3' edges of the chromosome, which would have otherwise
been missed.}
}
\value{
\code{GRangesList} with ranges that represent either DAR regions or
DAR origins, depending on the ranges of the input object.
}
\description{
Convert the ranges element associated with origin DAR values
to ranges associated with the region DAR values.
This function can also be used to revert back to the original object
containing origin ranges if desired.
}
\examples{
fl <- system.file("extdata", "chr1.vcf.bgz", package="tadar")
genotypes <- readGenotypes(fl)
groups <- list(
    group1 = paste0("sample", 1:6),
    group2 = paste0("sample", 7:13)
)
counts <- countAlleles(genotypes, groups)
counts_filt <- filterLoci(counts)
props <- countsToProps(counts_filt)
contrasts <- matrix(
    data = c(1, -1),
    dimnames = list(
        Levels = c("group1", "group2"),
        Contrasts = c("group1v2")
    )
)

## Establish regions using an elastic sliding window
dar <- dar(props, contrasts, region_loci = 5)
## Convert ranges to regions associated with dar_region values
dar_regions <- flipRanges(dar)
## Optionally extend the outer regions to completely cover chromosomes
dar_regions <- flipRanges(dar, extend_edges = TRUE)
## Convert back to origin ranges associated with dar_origin values
flipRanges(dar_regions)

## Establish regions using a fixed sliding window
dar <- dar(props, contrasts, region_fixed = 1001)
## Convert ranges to regions associated with dar_region values
dar_regions <- flipRanges(dar)
## Convert back to origin ranges associated with dar_origin values
flipRanges(dar_regions)

}
