% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/unphaseGT.R
\name{unphaseGT}
\alias{unphaseGT}
\alias{unphaseGT,matrix-method}
\alias{unphaseGT,data.frame-method}
\title{Unphase genotypes}
\usage{
unphaseGT(gt)

\S4method{unphaseGT}{matrix}(gt)

\S4method{unphaseGT}{data.frame}(gt)
}
\arguments{
\item{gt}{\code{matrix} or \code{data.frame} containing sample genotype information.}
}
\value{
\code{matrix} containing unphased genotype calls.
}
\description{
Remove phasing information from genotype calls.
}
\details{
Phasing information is not required for a simple DAR analysis.
Removing this enables easy counting of alleles from genotype calls.
}
\examples{
library(VariantAnnotation)
fl <- system.file("extdata", "chr1.vcf.bgz", package="tadar")
vcf <- readVcf(fl)
gt <- geno(vcf)$GT
unphaseGT(gt)

}
