% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggevonet.R
\name{node_depth_evonet}
\alias{node_depth_evonet}
\title{Depth of Nodes}
\usage{
node_depth_evonet(x, ...)
}
\arguments{
\item{x}{an object of class 'evonet'}

\item{\dots}{Further arguments passed to or from other methods.}
}
\value{
a vector with the depth of the nodes
}
\description{
These functions return the depths or heights of nodes and tips.
}
\examples{
z <- ape::read.evonet(text = '((1,((2,(3,(4)Y#H1)g)e,
(((Y#H1, 5)h,6)f)X#H2)c)a,((X#H2,7)d,8)b)r;')
nd <- node_depth_evonet(z)
z$edge.length <- nd[z$edge[,1]] - nd[z$edge[,2]]
ggevonet(z)

}
\seealso{
\code{\link[ape]{node.depth}}
}
