% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tof_tbl.R
\name{as_tof_tbl.flowSet}
\alias{as_tof_tbl.flowSet}
\title{Convert an object into a tibble-flowCore abstraction (a `tof_tbl`)}
\usage{
\method{as_tof_tbl}{flowSet}(
  flow_data,
  .name_method = c("tidyFlowCore", "featureNames", "colnames"),
  sep = "|",
  ...,
  include_metadata = FALSE,
  include_tidyFlowCore_identifier = FALSE
)
}
\arguments{
\item{flow_data}{A FlowSet}

\item{.name_method}{A string indicating how tidyFlowCore should extract column
names for the output tof_tbl from `flow_data`.
Available options are "tidyFlowCore" (the default), which
uses tidyFlowCore's internal heuristic to name columns; "featureNames", which
uses \code{\link[flowCore]{featureNames}} to name the columns; and "colnames",
which uses \code{\link[base]{colnames}} to name the columns.}

\item{sep}{A string to use to separate the antigen name and its associated
channel name in the column names of the output tibble. Defaults to "|".}

\item{...}{Currently unused.}

\item{include_metadata}{A boolean value indicating if the metadata for each
.fcs file read by flowCore (stored in \code{\link[Biobase]{pData}})
should be merged into the final result. Defaults to FALSE.}

\item{include_tidyFlowCore_identifier}{A boolean value indicating if
tidyFlowCore's internal identifier for each flowFrame in the flowSet
should be included in the output tof_tbl result. Defaults to FALSE.}
}
\value{
A cytometry-specialized tibble called a `tof_tbl`.
}
\description{
Convert an object into a tibble-flowCore abstraction (a `tof_tbl`)
}
