% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dplyr_verbs.R
\name{slice_min.flowSet}
\alias{slice_min.flowSet}
\title{Subset rows of a data structure in order.}
\usage{
\method{slice_min}{flowSet}(
  .data,
  order_by,
  ...,
  n,
  prop,
  by = NULL,
  with_ties = TRUE,
  na_rm = FALSE
)
}
\arguments{
\item{.data}{A \code{\link[flowCore]{flowSet}}}

\item{order_by}{Variable or function of variables to order by.
To order by multiple variables, wrap them in a data frame or tibble.}

\item{...}{Unused.}

\item{n, prop}{Provide either n, the number of rows, or prop, the proportion
of rows to select. If neither are supplied, n = 1 will be used.
If n is greater than the number of rows in the group (or prop > 1), the
result will be silently truncated to the group size. prop will be rounded
towards zero to generate an integer number of rows.

A negative value of n or prop will be subtracted from the group size.
For example, n = -2 with a group of 5 rows will select 5 - 2 = 3 rows;
prop = -0.25 with 8 rows will select 8 * (1 - 0.25) = 6 rows.}

\item{by}{Optionally, an unquoted selection of columns to group by for just this operation.
An alternative to group_by.}

\item{with_ties}{Should ties be kept together? The default, TRUE, may return
more rows than you request. Use FALSE to ignore ties, and return the first
n rows.}

\item{na_rm}{Should missing values in order_by be removed from the result?
If FALSE, NA values are sorted to the end so they will only be included if
there are insufficient non-missing values to reach n/prop.}
}
\value{
An object of the same type as .data. The output has the following properties:
* Each row may appear 0, 1, or many times in the output.
* Columns are not modified.
* Groups are not modified.
* A \code{\link[flowCore]{flowSet}}'s \code{\link[Biobase]{pData}} is preserved.
}
\description{
Subset rows of a data structure in order.
}
\examples{
my_flowset <- simulate_cytometry_data()$flowset

my_flowset |>
  dplyr::slice_max(order_by = feature_1, n = 10)


}
