% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dplyr_verbs.R
\name{slice_sample.flowFrame}
\alias{slice_sample.flowFrame}
\title{Subset rows randomly}
\usage{
\method{slice_sample}{flowFrame}(.data, ..., n, prop, by = NULL, weight_by = NULL, replace = FALSE)
}
\arguments{
\item{.data}{A \code{\link[flowCore]{flowFrame}}}

\item{...}{Unused.}

\item{n, prop}{Provide either n, the number of rows, or prop, the proportion
of rows to select. If neither are supplied, n = 1 will be used.
If n is greater than the number of rows in the group (or prop > 1), the
result will be silently truncated to the group size. prop will be rounded
towards zero to generate an integer number of rows.

A negative value of n or prop will be subtracted from the group size.
For example, n = -2 with a group of 5 rows will select 5 - 2 = 3 rows;
prop = -0.25 with 8 rows will select 8 * (1 - 0.25) = 6 rows.}

\item{by}{Optionally, an unquoted selection of columns to group by for just this operation.
An alternative to group_by.}

\item{weight_by}{Sampling weights. This must evaluate to a vector of
non-negative numbers the same length as the input.
Weights are automatically standardized to sum to 1.}

\item{replace}{Should sampling be performed with (TRUE) or without
(FALSE, the default) replacement.}
}
\value{
An object of the same type as .data. The output has the following properties:
* Each row may appear 0, 1, or many times in the output.
* Columns are not modified.
* Groups are not modified.
* A \code{\link[flowCore]{flowFrame}}'s \code{\link[flowCore]{identifier}} is preserved.
}
\description{
Subset rows randomly
}
\examples{

my_flowframe <- simulate_cytometry_data()$flowframe

 my_flowframe |>
   dplyr::slice_sample(n = 5)

}
