% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dplyr_verbs.R
\name{summarize.flowFrame}
\alias{summarize.flowFrame}
\title{Summarize a flowFrame.}
\usage{
\method{summarize}{flowFrame}(.data, ..., .by = NULL, .groups = NULL)
}
\arguments{
\item{.data}{.data A \code{\link[flowCore]{flowFrame}}}

\item{...}{Name-value pairs of summary functions.
The name will be the name of the variable in the result.}

\item{.by}{Optionally, a selection of columns to group by for just this
operation, functioning as an alternative to group_by().}

\item{.groups}{Grouping structure of the result.
* "drop_last": dropping the last level of grouping.
* "drop": All levels of grouping are dropped.
* "keep": Same grouping structure as .data.
* "rowwise": Each row is its own group.}
}
\value{
A data.frame containing the summarized result.
}
\description{
Summarize a flowFrame.
}
\examples{

my_flowframe <- simulate_cytometry_data()$flowframe

 my_flowframe |>
   dplyr::summarize(feature_1_mean = mean(feature_1))

}
