% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dplyr_verbs.R
\name{transmute.flowFrame}
\alias{transmute.flowFrame}
\title{Create, modify, and delete columns.}
\usage{
\method{transmute}{flowFrame}(.data, ...)
}
\arguments{
\item{.data}{A \code{\link[flowCore]{flowFrame}}}

\item{...}{Name-value pairs. The name (the left side of the equals sign)
gives the name of the column in the output. The right side of the equation
performs computations using the names of each channel according to
 \code{\link[flowCore]{featureNames}}. Supports tidyselection.}
}
\value{
A \code{\link[flowCore]{flowFrame}}. The output has the following
properties:
* Columns created or modified through ... will be returned in the order specified by ....
* The number of rows is not affected.
* Columns given the value NULL will be removed.
* The \code{\link[flowCore]{flowFrame}}'s \code{\link[flowCore]{identifier}} will be preserved.
}
\description{
Create, modify, and delete columns.
}
\examples{

my_flowframe <- simulate_cytometry_data()$flowframe

 my_flowframe |>
   dplyr::transmute(new_feature = feature_1 + feature_2)

}
