% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_dfs.R
\name{as_dfs}
\alias{as_dfs}
\title{Create a list of dataframes (full extraction)}
\usage{
as_dfs(sbml, type = "file")
}
\arguments{
\item{sbml}{either the path of the sbml file or the sbml already converted into a list, that is either a character string or a list respectively}

\item{type}{description about the type of the first argument (i.e. 'file' or 'list'), a character string}
}
\value{
a list of dataframes
}
\description{
It takes in input a sbml file (or sbml list) and returns a list of maximum 3 components, depending on which entities are actually reported in the sbml document.    The first component contains the dataframe for listOfCompartments data, the second one for listOfSpecies data while the third component contains maximum two dataframes about reactions info (one with reactions data and the other one with data about the species involved in each reaction).
}
\details{
This is the main function of the package. It comprehends all the other functions.
Since it incorporates also the sbml_as_list() function it is possible to insert as input either the sbml path or the sbml already converted into a list. This is set up using the argument 'type' which has to be 'file' or 'list', respectively.
}
\examples{
filepath <- system.file("extdata", "R-HSA-8937144.sbml", package = "tidysbml")

sbml_list <- sbml_as_list(filepath)
as_dfs(sbml_list, type = "list") ## returns a list of dataframes, giving in input the sbml already converted into a list

as_dfs(filepath, type = "file") ## returns a list of dataframes, giving in input the sbml path
}
