% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method-xml.R
\name{writeMethodXmls}
\alias{writeMethodXmls}
\title{Create Orbitrap Fusion Lumos method.xml files.}
\usage{
writeMethodXmls(exps, pattern = "method-\%s.xml", verbose = interactive())
}
\arguments{
\item{exps}{\code{list}, generated by e.g.
\code{\link[=createExperimentsFragmentOptimisation]{createExperimentsFragmentOptimisation()}}}

\item{pattern}{\code{character}, file name pattern for the method.xml files.}

\item{verbose}{\code{logical}, verbose output?}
}
\description{
This function is used to create Orbitrap Fusion Lumos method files from
a tree-like \code{list} experiment generated by e.g.
\code{\link[=createExperimentsFragmentOptimisation]{createExperimentsFragmentOptimisation()}}.
}
\details{
\itemize{
\item \code{exps}: a named tree-like \code{list} object generated by e.g.
\code{\link[=createExperimentsFragmentOptimisation]{createExperimentsFragmentOptimisation()}}. Its names are used as filename.
\item \code{pattern}: The file name pattern used to name different method files.
It must contain a \code{"\%s"} that is replaced by the conditions defined in
\code{groupBy}.
}

\strong{DEFUNCT} options:
\itemize{
\item \code{ms1Settings}:
A \code{list} of MS1 settings. This has to be a named \code{list}.
Valid MS1 settings are:
\code{c("FirstMass", "LastMass", "Microscans", "MaxITTimeInMS", "AgcTarget")}
\item \code{ms2Settings}:
A \code{list} of MS2 settings. This has to be a named \code{list}.
Valid MS2 settings are:
\code{c("ActivationType", "IsolationWindow", "EnableMultiplexIons", "EnableMSXIds", "MaxNoOfMultiplexIons", "OrbitrapResolution", "AgcTarget", "MinAgcTarget", "MaxITTimeInMS", "Microscans", "ETDReactionTime", "ETDReagentTarget", "MaximumETDReagentInjectionTime", "UseInternalCalibratedETD", "ETDSupplementalActivationEnergy", "ETDSupplementalActivation")}
\item \code{groupBy}: The \code{groupBy} parameter is used to split methods into
different files. Valid entries are all settings that could be used in
\code{ms2Settings} and \code{"replication"}.
\item \code{massLabeling}: The Orbitrap Fusion devices seems not to respect the
start and end times of the runs given in the method.xml files. That's why it
is nearly impossible to identify the run with its conditions based on the
timings. If \code{massLabeling} is \code{TRUE} (default) the mass values given
in \code{mz} are rounded to the first decimal place and the second to fourth
decimal place is used as numeric identifier.
}
}
\examples{
ms1 <- expandMs1Conditions(FirstMass=400, LastMass=1200, Microscans=as.integer(10))

targetMz <- cbind(mz=c(560.6, 700.5, 933.7), z=rep(1, 3))
common <- list(
    OrbitrapResolution="R120K",
    IsolationWindow=1,
    MaxITTimeInMS=200,
    Microscans=as.integer(40),
    AgcTarget=c(1e5, 5e5, 1e6)
)
cid <- expandTms2Conditions(
    MassList=targetMz,
    common,
    ActivationType="CID",
    CIDCollisionEnergy=seq(7, 35, 7)
)
hcd <- expandTms2Conditions(
    MassList=targetMz,
    common,
    ActivationType="HCD",
    HCDCollisionEnergy=seq(7, 35, 7)
)
etd <- expandTms2Conditions(
    MassList=targetMz,
    common,
    ActivationType="ETD",
    ETDReagentTarget=c(1e6, 5e6, 1e7),
    ETDReactionTime=c(2.5, 5, 10, 15, 30, 50),
    ETDSupplementalActivation=c("None", "ETciD", "EThcD"),
    ETDSupplementalActivationEnergy=seq(7, 35, 7)
)
exps <- createExperimentsFragmentOptimisation(ms1=ms1, cid, hcd, etd,
    groupBy=c("AgcTarget", "replication"), nMs2perMs1=10, scanDuration=0.5,
    replications=2, randomise=TRUE
)
writeMethodXmls(exps=exps)
}
\seealso{
\code{\link[=createExperimentsFragmentOptimisation]{createExperimentsFragmentOptimisation()}}
}
\author{
Sebastian Gibb \email{mail@sebastiangibb.de}, Pavel V. Shliaha
\email{pavels@bmb.sdu.dk}
}
